{
Copyright  DSS, Inc.
All Rights Reserved.

PURPOSE:  A large collection of useful functions/procedures that can be used in any project.
 AUTHOR:  Brian Smith
  DATES:  MM/DD/YY BS <= 1.06 1st version.
          11/07/08 JAC 2.0 Added xtra routines.  Formatted code. Moved Show* functions
                           to dssMessageBox.  Moved Piece & to VistaPiece uDSSPiece.
          03/16/09 JAC 2.1 Added function GetVersionInfoStr.
          04/24/09 JAC 2.2 Fix to GetVersionInfo so minor & build are properly returned (was $FFF vs $FFFF).
          05/29/09 JAC 2.3 Added new function DoIExist which will return TRUE if you application is already running.
          07/19/10 WLS ?.? Added new functions Str[C]Spn 
  NOTES:
}
unit dsslibrary;

interface

uses
  IniFiles, Windows, Registry, ShellAPI, Messages, SysUtils, Classes, Menus,
  Graphics, Controls, Forms, Dialogs, StdCtrls, Math, ComCtrls, mmsystem, FileCtrl,
  ExtCtrls, Grids,
  //spin,
  variants, CheckLst,dssconst, buttons;

type
  PDynString = ^TDynString;
  TDynString = array[0..0] of char;

  TSmartOptions      = set of (ssoSaveListContents, ssoAppend, ssoUseSection);
  TSmartClearOptions = set of (scoClearAllComponents, scoClearLists);

  //Dynamic arrays - very useful instead of TStringList;
  TDSArray = array of string;
  TDIArray = array of integer;
  TDDArray = array of double;
  TDVArray = array of variant;
  
  // for StrSpn/StrCSpn
  TCharSet = Set of char;
  
  //Used to attach a string value to a TTreeNode or something else
  //which only has a .Data property
  //Moved to uStringObject, with helper functions too
{  TMyStringObject = class(TObject)
  public
    Text  :string;
  end;
  }

  EDSSError = class(Exception);

  TFileVersion = record
      Major: word;
      Minor: word;
      Release: word;
      Build: word;
  end;

const
  POSBIGCROSSOVER = 8;       //Number of characters above which we should call PosBig instead of Pos

var
    gbKeepHourglass:boolean;//a flag to force the ShowHour to stay up - used in "nested" situations
  bNoEvents : boolean;
    SINDelim:string;
    SINCol:integer;

function RGBHexToColour(sRGB :String) :TColor;   //Pass it FFFFFF and it returns a TColor
function GetHexColourStr(color: TColor): String; //e.g Returns FFFFFF
procedure AddDisableBMP(SB : array of TObject);
function AppDir: string;                         //Returns dir of application.exename
procedure AppendToFile(sFile, sLine: string);
function AskYesNo(sQuestion: string): boolean;   //Puts up a Yes / No dialog. Returns true if Yes is chosen
function Between(sChunk, sStart, sEnd: string): string;

function ChopAfter(sVictim, sTarget: string; bReturnOriginal: boolean): string;
function ChopBefore(sVictim, sTarget: string; bReturnOriginal: boolean): string;
procedure ClearGrid(sg: TStringGrid; bClearFixed: boolean);

function CountCheckListChecked(chklst: TCheckListBox): integer;
function CountWildcard(sWildcard: string; bRecurse: boolean = false): integer;
function CopyDirTree(sWildPath, sDestRoot: string): integer;    //Mirrors a dir tree to another dir
procedure DeleteDirFiles(sWildPath: string; bRecurse: boolean);
procedure DeleteFiles(slFiles: TStringList);
function DirPathFix(const ADirPath: string): string;
function DssLibEncrypt(sSource: string): string;
procedure EnableChildren(cnt: TWinControl; bEnabled: boolean);
function ExecProgram(sEXE: string; sParameters: string = ''; iWindowMode: integer = SW_SHOWNA): integer;
procedure ExpandWildcards(sWildPath: string; slResult: TStringList; bRecurse: boolean = false);
function FormatAsMoney(fNumber:single;iPrecision:integer=2):string;

function FindTreeViewNodeByText(tv: TTreeView; sText: string): TTreeNode;
function GetNodeRootParent(tv:TTreeView;oNode:TTreeNode):TTreeNode;

function FilePath(sDir, sFile: string): string;  //Works with \ or / delimited paths
function GetColumnIndexByName(lv:TListView;sHeading:string):integer;
procedure GetSubDirs(sStartPath: string;
    var slResult: TStringList; bRecurse: boolean = false; bIncludeStartPath: boolean = true);
function GetVersionInfo(var VersionInfo: TFileVersion; sEXEFile: string = ''): boolean;
function GetVersionInfoStr( sEXEFile: string = ''): string;
procedure HideHour;
procedure HideTabs(pcPageControl:TPagecontrol);
function IsFileReadOnly(sFile: string): boolean;
function IsNumeric(vTest: variant): boolean;
function IsNumericNoException(sTest: string): boolean;
function AlreadyInListView(lv: TListview; sCaption: string): boolean;
function ListViewItemToString(oItem:TListItem;sDelimiter:string='^'):string;
function AlreadyInTreeView(tv: TTreeView; sCaption: string): boolean;
function ListViewIndexOfByCaption(lv: TListview; sCaption: string): integer;

function MedianInteger(x: TDIArray): integer;
procedure MoveListViewItemToIndex(lv: TListView; oItemToMove: TListItem;
    iNewIndex: integer; bRetainSelectionAfterMove: boolean = true;bSwapItems:boolean=true);
function MyGetUserName: string;
function MyGetComputerName: string;
function MyWrapText(const Line, BreakStr: string;
    const BreakChars: TSysCharSet; MaxCol: integer; bEnforceMaxCol: boolean = true): string;
    overload;
function MyWrapText(const Line: string;
    MaxCol: integer=80; bEnforceMaxCol: boolean = true): string; overload;

function ParseLine(sWhole: string; sDelimiter: variant; var slResult: TStringList): integer;
function UnParseLine(slData: TStringList; sDelimiter: string): string;
//function VistaPiece(sSource: string; iPiece: integer): string;

//function Piece(sSource, sDelimiter: string; iPiece: integer): string;
function ProperCase(s: string): string;
function ReadWholeFile(sfilename: string; fmShareMode: word = fmOpenRead or fmShareDenyNone): string;
function RemoveFromListView(lv: TListView;bAskUser:boolean=true): boolean;
procedure RemoveFromListBox(lst: TListBox; bAskFirst: boolean = true);
procedure RemoveFromTreeView(tv: TTreeView; bAskFirst: boolean = true);
procedure ResizeControls(frm: TForm; iLastWidth, iLastHeight: integer);
function ROT13(sString: string): string;
procedure SelectFirstItem(ctl:TControl);
procedure SetListBoxHorizontalScroll(lst: TListBox);
procedure ScrollToTop(ctl:TCustomEdit);
procedure SetFocusInPageControl(ctlControl: TWinControl);
procedure SetAllListViewColumnsToMaxWidth(lvListView: TListView; bFitHeader: boolean = false);
procedure SetAllListViewColumnsToFixedWidth(lvListView: TListView;iWidth: integer=50);
procedure SetCheckListAllChecked(chklst: TCheckListBox; bChecked: boolean);
procedure SetListBoxAllSelected(lst: TListBox; bChecked: boolean);
procedure ShowHour;

procedure SmartClear(cmp: TComponent; scoOptions: TSmartClearOptions);
function SmartLoad(sFile: string; cmp: TComponent; slOptions: TSmartOptions;
    iMin, iMax: integer): boolean;
procedure SmartSave(sFile: string; cmp: TComponent; ssOptions: TSmartOptions;
    iMin, iMax: integer);
procedure SortDataInStringList(var slData:TStringList;iCol:integer;sDelim:string='^';iMethod:integer=0);
function TypeNumberOnly(key: char;bAllowDecimal:boolean=true): char;

procedure WriteWholeFile(sfilename, sContents: string);

function AddItemToListBox(sLine: string; lstDest: Tlistbox;
    bPreventDuplicates: boolean = true): boolean;
function AddItemToListView(sLine: string; lvDest: Tlistview;
    bPreventDuplicates: boolean = true;slSubItems:TStrings=nil): boolean;
function CopyBetweenListBoxes(lstSource, lstDest: TListBox;
    bPreventDuplicates: boolean = true; bAutoHorizScroll: boolean = true): boolean;
function CopyBetweenListViews(lvSource, lvDest: TListView;
    bPreventDuplicates: boolean = true; bAutoHorizScroll: boolean = true): boolean;

function ReplaceString(sString, sCulprit, sNewString: string;
    bCaseSensitive: boolean = false): string;
function ReplaceStringNum(sString, sCulprit, sNewString: string;
    var iNumber: integer; bCase: boolean): string;

function PosBig(sCulprit, sString: string): integer;

function LeftConTrim(sString, sTarget: string): string; //Left only
function RightConTrim(sString, sTarget: string): string; //Trailing
function ConTrim(sString, sTarget: string): string; //Trims both sides
function RemoveTrailing(sWhole, sToRemove: string): string;

function GetTemporaryPath: string;
function GetTemporaryFile(sFilePrefix: string): string;
function WriteTemporaryFile(sFileContents, sExt, sNameStart: string): string;

function GetSystemPath: string;
function GetWindowsPath: string;
function GetWindowsUserName:string;

function SortListView(Item1, Item2: TListItem; bSortAscending: boolean;
    iColumnIndex: integer; iSortType: integer = 0): integer;
function GetCommandLineValueByName(sName: string): string;

function MakeTextTwoColumns(sAllText:string;iColWidth:integer):string;
function MapExtended(fNumber,fOriginalLow,fOriginalHigh,fNewLow,fNewHigh:extended):extended;
function MapInteger(iNumber,iOriginalLow,iOriginalHigh,iNewLow,iNewHigh:integer):integer;

function DoIExist(WndTitle: string): boolean;    {!!2.3}

// Count span in complement of charset
// Returns the number of characters in the left span of Str starting at Idx
// which are not in Chars.
function StrCSpn(Str: string; Chars: TCharSet; Idx: integer): integer;

// Count the span in charset
// Returns the number of characters in the left span of Str starting at Idx
// which are in Chars
function StrSpn(Str: string; Chars: TCharSet; Idx: integer): integer;

implementation

uses
  StrUtils, DateUtils, dssBool, fmDateTime, uDSSPiece, dssMessageBox;

var
  fClickEvent: TNotifyEvent;

Function RGBHexToColour(sRGB :String) :TColor;
//Pass it FFFFFF and it returns a TColor
var
  rgbResult: TRGBTriple;
  lRGB : TColor;
begin
  try
    rgbResult.rgbtRed := strtoint('$' + Leftstr(sRGB, 2));
    rgbResult.rgbtGreen := strtoint('$' + Midstr(sRGB, 3, 2));
    rgbResult.rgbtBlue := strtoint('$' + Rightstr(sRGB, 2));
    lRGB := RGB(rgbResult.rgbtRed, rgbResult.rgbtGreen, rgbResult.rgbtBlue);
    Result := lRGB;
  except
    on EConvertError do
      begin
        //If they've passed in a stupid colour code
        Result := clBtnFace;
        raise;
      end
    else
      raise;
    end;
end;

function GetHexColourStr(color: TColor): String;
//See also ColourToThreeBytes which returns the RGB values
var
  sColour: String;
begin
  //You can pass it the constants for system colors now.
  color := ColorToRGB(color);
  sColour := copy(IntToHex(Color, 8), 7, 2) + copy(IntToHex(Color, 8), 5, 2) + copy(IntToHex(Color, 8), 3, 2);
  Result := sColour;
end;

function ParseLine(sWhole: string; sDelimiter: variant;  var slResult: TStringList): integer;
// ParseLine chops up sWhole using sDelimiter and places the results in the string
//  list sResult Possible Variations - don't clear the sResult before adding to it. 
var
  sWork: string;
  sTemp: string;

  bDone:  boolean;
  bIsVar: boolean;
  ipos:   integer;

  iLenDelim:  integer;
  istringmax: integer;
begin
  slResult.Clear;
  sWork  := sWhole;
  bIsVar := VarIsNull(sDelimiter);
  if bIsVar = true then
    stemp := chr(0)
  else
    sTemp := sDelimiter;

  //iLenDelim := Length(sDelimiter);
  iLenDelim  := Length(sTemp);
  istringmax := Length(sWhole);
  bDone      := false;
  while bDone <> true do
    begin
      if Length(sWork) > 0 then
        begin
          ipos := pos(stemp, sWork);
          if ipos > 0 then
            begin
              slresult.add(Copy(sWork, 1, ipos - 1));
              sWork := copy(sWork, ipos + ilendelim, istringmax);
            end
          else
            begin
              //that's the last one
              slResult.Add((sWork));
              bDone := true
              //strDispose(sWork);
            end;
        end
      else
        bDone := true;
    end;
  Result := slResult.Count - 1;
end;

function UnParseLine(slData: TStringList; sDelimiter: string): string;
// The oppposite of the ParseLine function.  Turn a TStringList into a string,
// delimiting each item with sDelimiter
var
  ilp: integer;
begin
  Result := '';
  for ilp := 0 to slData.Count - 1 do
    begin
      Result := Result + slData[ilp] + sDelimiter;
    end;
  Result := rightcontrim(Result, sDelimiter);
end;

function ReadWholeFile(sfilename: string; fmShareMode: word = fmOpenRead or fmShareDenyNone): string;
// Read the contents of a file and return it all as a string.
var
  fsFile:  TFileStream;
  iSize:   integer;
  pBuffer: PDynString;
  sResult: string;
begin
  fsFile := TFileStream.Create(sFileName, fmOpenRead or fmShareMode);
  Result := '';
  try
    try
      iSize := fsFile.Size;
      GetMem(pBuffer, iSize);
      fsFile.Read(pBuffer^, iSize);
      sResult := string(pchar(pBuffer));
      SetLength(sResult, iSize);
      Result := sResult;
      FreeMem(pBuffer, iSize);
    except
      on e: EInOutError do
        begin
          if e.ErrorCode = 2 then //That's the file not found error
            ShowMessage(e.message + ' : ' + sFilename)
          else if e.ErrorCode = 3 then
            ShowMessage(sFilename + ' not found.');
        end;
    end;
  finally
    fsFile.Free;
  end;
end;

procedure WriteWholeFile(sfilename, sContents: string);
// Often used with ReadWholeFile, this procedure writes sContents into file sFilename.
// The file is created if it did not exist, or is overwritten if it did. Use AppendToFile
// if you don't want to overwrite.
var
  fFile: textfile;
begin
  try
    AssignFile(fFile, sFileName);
    try
      Rewrite(fFile);
      Write(fFile, sContents);
    except
      //Pass the error up
      raise //EDSSError.create(e.message);
    end;
  finally;
    CloseFile(fFile);
  end;
end;

function WriteTemporaryFile(sFileContents, sExt, sNameStart: string): string;
//V1.06 - you can specify the file extension the temp file will have.
//IE, for example, won't show a file unless its .htm or .html - bastard...

//sNameStart is the beginning portion of the temporary file - makes it easier
//to delete them "en-masse" later on
var
  sTempFile: string;
begin
  //Write sFileContents out to a temporary file.  Return the
  //name of the temporary file
  //sTempPath := GetTemporaryPath;
  sTempFile := GetTemporaryFile(sNameStart);
  Result    := '';
  if sTempFile > '' then
    begin
      if sExt > '' then
        begin
          if copy(sExt, 1, 1) <> '.' then
            sExt := '.' + sExt;

          //Delete the temporary file that got created by calling GetTemporaryFile
          //We'll be writing our own file in a second...we only wanted a unique name
          deletefile(sTempFile);

          sTempFile := ChangeFileExt(sTempFile, sExt);
        end;

      WriteWholeFile(sTempFile, sFileContents);
      Result := sTempFile;
    end;
end;

function GetTemporaryFile(sFilePrefix: string): string;
// Get the path and filename for a temporary file
var
  sBuffer: pchar;
  sPath:   string;
  sPrefix: pchar;
begin
  sBuffer := stralloc(256);
  sPath   := GetTemporaryPath;

  if sFilePrefix = '' then
    sPrefix := 'tmp'                             //Default to the normal prefix
  else
    sPrefix := pchar(sFilePrefix);

  GetTempFileName(pchar(sPath), sPrefix, 0, sBuffer);

  if sBuffer > '' then
    Result := strpas(sBuffer);
end;

function GetTemporaryPath: string;
// Gets the path which windows thinks is the user's temp directory
var
  sBuffer:   pchar;
  iSize:     integer;
  sTempPath: string;
begin
  Result  := '';
  sBuffer := StrAlloc(256);
  iSize   := GetTempPath(255, sBuffer);
  if iSize > 0 then
    begin
      sTempPath := copy(sBuffer, 1, iSize);
      Result    := sTempPath;
    end;
  StrDispose(sBuffer);
end;

function ReplaceString(sString, sCulprit, sNewString: string; bCaseSensitive: boolean = false): string;
// DELPHI NOW HAS STRINGREPLACE FUNCTION TO DO THIS
// I'm leaving it here because many other dssLibrary.pas functions call it,
// but they could be replaced with calls to StringReplace
//
// Originally from sausage.pas
// ReplaceString - tied to ReplaceStringNum MAKE SURE THEY'RE THE SAME !
// Given a string sString, replace each instace of sCulprit
// with sNewString and return the converted string.
//
// BSMITH - optimized by adding lowercase calls and removing
// instr calls - too many lowercase calls :(
var
  iOffAndPos, iOffset, iBig, iLenNew, iLenCul, iPos: integer;
  sChunk:  string;
  sWork:   string;
  sLowerChunk, sLowerCulprit: string;
  bUseBig: boolean;
begin
  //Use the lowercase versions for the pos checks
  //but not for the actual adding to strings, or we'll
  //be forcing everything to lowercase ! Ugly...

  sChunk := sString;
  sWork  := sString;
  if bCaseSensitive then
    begin
      //Keep same vbl names to simplify algorithm below
      sLowerChunk   := sChunk;
      sLowerCulprit := sCulprit;
    end
  else
    begin
      sLowerChunk   := ansilowercase(sChunk);
      sLowerCulprit := ansilowercase(sCulprit);
    end;

  iLenCul := length(sCulprit);
  bUseBig := (iLenCul > POSBIGCROSSOVER) and bCaseSensitive;
  iLenNew := length(sNewString) - 1;
  iBig    := Length(sLowerChunk); //Big number

  if bUseBig then
    iPos := PosBig(sLowerCulprit, sLowerChunk)
  else
    iPos := Pos(sLowerCulprit, sLowerChunk);

  iOffset := 0;

  while iPos > 0 do
    begin
      iOffAndPos := iOffset + iPos;
      Delete(sWork, iOffAndPos, iLenCul);
      Insert(sNewString, sWork, iOffAndPos);

      iOffset := iOffAndPos + (iLenNew);
      sChunk  := copy(sChunk, iPos + iLenCul, iBig);

      //It'd be nice if this didn't have to happen every loop....
      if bCaseSensitive then
        sLowerChunk := sChunk
      else
        sLowerChunk := ansilowercase(sChunk);

      if bUseBig then
        iPos := PosBig(sLowerCulprit, sLowerChunk)
      else
        iPos := Pos(sLowerCulprit, sLowerChunk);
    end;
  //sWork := sWork + sChunk;
  Result := sWork;
end;

function ReplaceStringNum(sString, sCulprit, sNewString: string;
    var iNumber: integer; bCase: boolean): string;
// Originall from sausage.pas
// Given a string sString, replace each instace of sCulprit with sNewString and
// return the converted string. Put the number of replacements made into iNumber
// NOTE: tied to ReplaceString MAKE SURE THEY'RE THE SAME!
var
  iOffAndPos, iOffset, iBig, iLenNew, iLenCul, iPos: integer;
  sChunk:  string;
  sWork:   string;
  sLowerChunk, sLowerCulprit: string;
  bUseBig: boolean;
begin
  //Use the lowercase versions for the pos checks
  //but not for the actual adding to strings, or we'll
  //be forcing everything to lowercase ! Ugly...

  sChunk := sString;
  sWork  := sString;
  if bCase then
    begin
      //Keep same vbl names to simplify algorithm below
      sLowerChunk   := sChunk;
      sLowerCulprit := sCulprit;
    end
  else
    begin
      sLowerChunk   := ansilowercase(sChunk);
      sLowerCulprit := ansilowercase(sCulprit);
    end;

  iLenCul := length(sCulprit);
  bUseBig := (iLenCul > POSBIGCROSSOVER) and bCase;
  iLenNew := length(sNewString) - 1;
  iBig    := Length(sLowerChunk); //Big number

  if bUseBig then
    iPos := PosBig(sLowerCulprit, sLowerChunk)
  else
    iPos := Pos(sLowerCulprit, sLowerChunk);

  iOffset := 0;

  while iPos > 0 do
    begin
      iOffAndPos := iOffset + iPos;
      Delete(sWork, iOffAndPos, iLenCul);
      Insert(sNewString, sWork, iOffAndPos);

      iOffset := iOffAndPos + (iLenNew);
      sChunk  := copy(sChunk, iPos + iLenCul, iBig);

      //It'd be nice if this didn't have to happen every loop....
      if bCase then
        sLowerChunk := sChunk
      else
        sLowerChunk := ansilowercase(sChunk);

      if bUseBig then
        iPos := PosBig(sLowerCulprit, sLowerChunk)
      else
        iPos := Pos(sLowerCulprit, sLowerChunk);

      Inc(iNumber);
    end;
  //sWork := sWork + sChunk;
  Result := sWork;
end;

function ChopBefore(sVictim, sTarget: string; bReturnOriginal: boolean): string;
// Originally from sausage.bas
// Given a string sVictim, return the portion of sVictim after sTarget
var
  lTargetPoint: integer;
begin
  lTargetPoint := pos(sTarget, sVictim);
  if lTargetPoint > 1 then
    ChopBefore := LeftStr(sVictim, lTargetPoint - 1)
  else if bReturnOriginal then
    ChopBefore := sVictim
  else
    ChopBefore := '';
end;

function ChopAfter(sVictim, sTarget: string; bReturnOriginal: boolean): string;
// Originally from sausage.bas
// Slightly misleading name: this returns the portion of sVictim that appears AFTER sTarget.
// if bReturnOriginal is true then if sTarget is NOT found in sVictim, the whole of sVictim
// will be returned instead of <blank> ''.
var
  lTargetPoint: integer;
begin
  lTargetPoint := pos(sTarget, sVictim);
  if lTargetPoint > 0 then
    ChopAfter := copy(sVictim, lTargetPoint + Length(sTarget), Length(sVictim))
  else if bReturnOriginal then
    ChopAfter := sVictim
  else
    ChopAfter := '';
end;

function Between(sChunk, sStart, sEnd: string): string;
// Originally from sausage.bas
// Given a string sChunk, return the portion of sChunk between sStart and sEnd.
// ie Between('2','5','1234567') returns '34'.
var
  sResult: string;
begin
  sResult := ChopAfter(sChunk, sStart, false);
  sResult := ChopBefore(sResult, sEnd, false);
  Between := sResult;
end;

function TypeNumberOnly(key: char;bAllowDecimal:boolean=true): char;
var
  bOK,bMetaKey: boolean;
  cBack:char;
begin
  //In your edit fields OnKeyPress event
  //char := TypeNumberOnly(char);

  //Only do the check if the ctrl or shift keys aren't held down.
  //That allows cut,copy and paste operations to pass through OK
  //The evil shift-insert/shift-delete etc stuff works without going
  //through keypress events, so it'll be fine without any coding

  bMetaKey := (Ord(key) = 24) or (Ord(key) = 22) or (Ord(key) = 3); //Ctrl-X,V and C
  Result   := key; //Default

  if not bMetaKey then
    begin
      cBack := chr(VK_BACK);
      bOK := (key in ['0'..'9',cBack]);
      if not bOK then
        begin
          bOK := bAllowDecimal and (key = '.');
        end;

      if not bOK then
        Result := #0
    end;
end;

procedure ExpandWildcards(sWildPath: string; slResult: TStringList;
    bRecurse: boolean = false);
// Originall from sausage.bas / BSMITH
// Give a directory/file wildcard, populate a TStringList with all the matching filenames.
var
  Result:      TSearchRec;
  sWildcard, sPath: string;
  slSubDirs:   TStringList;
  iDirLP, iOK: integer;

  sExt: string;
  bCheckExt, bUseIt: boolean;
begin
  //Bsmith
  //Expand a wildcard and return the list of files that match it.

  bUseIt    := true;
  sPath     := extractfilepath(sWildpath);
  sExt      := extractfileext(sWildpath);
  sWildcard := extractfilename(sWildpath);
  bCheckExt := false;
  if Pos('*', sExt) = 0 then
    bCheckExt := true;

  slSubDirs := TStringList.Create;
  try
    slSubDirs.add(sPath);

    if bRecurse then
      begin
        GetSubDirs(sPath, slSubDirs, true);
      end;

    for iDirLP := 0 to slSubDirs.Count - 1 do
      begin
        iOK := findfirst(filepath(slSubDirs[iDirLP], sWildcard), 0, Result);
          if iOK = 0 then
            begin
              repeat
{ TODO : JAC:  Why is the BEGIN/END pair here? }
                begin
                  if bCheckExt then
                    begin
                      bUseIt := true;
                      if comparetext(extractfileext(Result.Name), sExt) <> 0 then
                        bUseIt := false;
                    end;
                end;
                if bUseIt then
                  slResult.add(filepath(slSubDirs[iDirLP], Result.Name));

                iOK := findNext(Result);
              until iOK <> 0;
            end;
      end;
    findclose(Result);
  finally
    slSubDirs.Free;
  end;
end;

function FilePath(sDir, sFile: string): string;
//Copes with DOS or URL style paths.  Actually this just joins ANY two
//items together, defaulting to DOS style unless it finds a URL slash in
//the sDir parameter.
var
  sSlash: string;
begin
  //Special case - if sDir is blank then
  //just return sFile, otherwise we're saying that
  //it defaults to root (ie /foobar.txt)
  if sDir = '' then
    begin
      Result := sFile;
      exit;
    end;

  if Pos('/', sDir) > 0 then
    sSlash := '/'
  else
    sSlash := '\';

  //this could be rightcontrim now
  sDir := rightcontrim(sdir,sSlash);

  sFile := leftcontrim(sFile,sSlash);

  Result := sDir + sSlash + sFile;
end;

procedure ShowHour;
// Change the cursor to an hourglass
begin
  screen.cursor := crHourglass;
end;

procedure HideHour;
// Change the screen.cursor to a normal pointer (used with ShowHour to display an hourglass).
begin
    //Use gbKeepHourglass := true if you're making multiple calls, each of which
    //might call HideHour, but you want to keep the hourglass up till the last one is done
    if gbKeepHourglass  then
        exit
    else
        screen.cursor := crDefault;
end;

procedure GetSubDirs(sStartPath: string;
    var slResult: TStringList; bRecurse: boolean = false; bIncludeStartPath: boolean = true);
// Builds a list of subdirectories under a given parent directory.
// You can include the parent and also recurse if you wish.
var
  iOK:    integer;
  Result: TSearchRec;
  sLastChar, sTemp, sAbsPath: string;
  iStartPathLength, ilp: integer;
begin
  //Specifically include directories in this list
  iOK := findfirst(filepath(sStartPath, '*.*'), faDirectory, Result);
  if iOK = 0 then
    repeat
      begin
        if (Result.attr and faDirectory > 0) then
          begin
            if (Result.Name <> '.') and (Result.Name <> '..') then
              begin
                sAbspath := filepath(sStartPath, Result.Name);
                slResult.add(sAbsPath);
                if bRecurse then
                  GetSubDirs(sAbsPath, slResult, bRecurse);
              end;
          end;
        iOK := FindNext(Result)
      end;
    until iOK <> 0;
  FindClose(Result);

  if not bIncludeStartPath then
    begin
      iStartPathLength := length(sStartPath);
      sLastChar := rightstr(sStartPath, 1);
      if (sLastChar = '\') or (sLastChar = '/') then
        //Add one character to the length, because it included a slash char
        //which we to trim off
        Inc(iStartPathLength);

      for ilp := 0 to slResult.Count - 1 do
        begin
          sTemp := copy(slResult[ilp], iStartPathLength + 2, length(slResult[ilp]));
          slResult[ilp] := sTemp;
        end;
    end;
end;

function RemoveFromListView(lv: TListView;bAskUser:boolean=true): boolean;
//Ask, then remove selected items from lv.
//Return false if they said 'No'.
//DO NOT USE THIS IF THE LV.ITEMS HAVE OJBECTS ATTACHED WHICH SHOULD BE FREED
//THIS WILL NOT DO THAT FOR YOU, AND YOU'LL LEAK MEMORY.
var
  ilp: integer;
  bOKToDelete:boolean;
begin
  Result := false;
  if lv.selected <> nil then
    begin
      if bAskUser then
        bOKToDelete :=  application.messagebox(
          'Are you sure you want to remove the selected items(s)?', 'Removing From List',
          MB_ICONQUESTION + MB_YESNO) = idYes
      else
        bOKToDelete := true;

      if bOKToDelete then
        begin
          Result := true;
          for ilp := lv.items.Count - 1 downto 0 do
            begin
              //Remove the current item from the list
              if lv.items[ilp].selected then
                lv.items[ilp].Delete;
            end;
        end;
    end;
end;

function DssLibEncrypt(sSource: string): string;
// A simple XOR encryption/decryption using "All Rights Reserved" as the key.
// sSource = the string you wish to encrypt or decrypt.
// sKey = the password with which to encrypt the string.
var
  l:     integer;
  X:     integer;
  char:  integer;
  sResult: string;
  sKey:  string;
  iTest: integer;
begin
  sKey := 'All rights reserved';

  sResult := sSource;
  l := Length(sKey);

  if l <> 0 then
    begin
      for X := 1 to Length(sSource) do
        begin
          if (X mod l) = 0 then
            iTest := -1
          else
            iTest := 0;
          char := Ord(sKey[(X mod l) - l * (iTest)]);
          sResult[X] := Chr(Ord(sResult[X]) xor char);
        end;
      DssLibEncrypt := sResult;
    end;
end;

function IsNumeric(vTest: variant): boolean;
// Returns true if a string can be put through strtofloat. This works on integer and floating point numbers.
var
  iTemp: single;
begin
  Result := true;
  try
    iTemp := StrToFloat(vTest);
  except
    on EConvertError do
      Result := false;
  end;
end;

function IsNumericNoException(sTest: string): boolean;
var
  ilp:integer;
begin
  //Doesn't raise an exception for the purpose of testing whether a string
  //contains all numeric chars (including "-" and ".")
  Result := true;

  //Using subscripts to access characters in strings is done from 1-base, not zero
  for ilp := 1 to length(sTest) do
    begin
      if not (sTest[ilp] in ['0'..'9','-','.']) then
        begin
          result := false;
          break;
        end;
    end;
end;

procedure ResizeControls(frm: TForm; iLastWidth, iLastHeight: integer);
// Resize all controls on the form
var
  aControl: TControl;
  wFactor:  single;
  hFactor:  single;
  ilp:      integer;
begin
{'THIS IS SOOOOO DAMN COOL !

'I wrote this so we could give VSOCX the arse and resize our own damned controls.

'REQUIREMENTS - pay careful attention, or it's not going to work
'1) The form being resize needs to have form_iLastWidth and form_iLastHeight declared
'   as form level variables
'2) On form load, set form_iLastWidth = Me.Width and form_iLastHeight = Me.Height
'   That "initializes" things
'3) On form_resize call ResizeControls Me,form_iLastWidth,form_iLastHeight
'   WIDTH, THEN HEIGHT ! WIDTH, THEN HEIGHT ! WIDTH, THEN HEIGHT !!!!!
'4) Right after the call to this routine, still in the form_resize event, set
'   form_iLastWidth = Me.Width and form_iLastHeight = Me.Height.  This means its
'   ready with the correct new values the next time it gets called

'This routine will resize all controls on a form, except for the Height of text
'boxes.  If you have list boxes, or any other control with IntegralHeight = true
'then this WILL NOT WORK !!!  You need to set that value to false first.  If your
'form has dirlist or filelist controls then forget using this routine - you can't
'change their IntegralHeight properties :(

}
  if bNoEvents then
    Exit;

  if frm.WindowState = wsMinimized then
  { BZZT! Very bad thing - this shouldn't be called if the form is minimized }
    Exit;

  if (iLastWidth = 0) or (iLastHeight = 0) then
  { These values are likely to be zero first time
    because frm.Show causes a resize on first display }
    Exit;

  wFactor := frm.Width / iLastWidth;
  hFactor := frm.Height / iLastHeight;

{  ''lOK = LockWindow(frm.hwnd)}

  for ilp := 0 to frm.ControlCount - 1 do
    begin
      aControl := frm.Controls[ilp];

      if not (aControl is TEdit) and not (aControl is TButton) then
        //Don't fiddle with their height - it's integral, like default list box behaviour
        aControl.Height := round(aControl.Height * hFactor);

      aControl.Width := round(aControl.Width * wFactor);
      aControl.Left  := round(aControl.Left * wFactor);
      aControl.top   := round(aControl.top * hFactor);
    end;
 //    ''lOK = LockWindow(0)
 //    frm.Refresh;
end;

procedure DeleteDirFiles(sWildPath: string; bRecurse: boolean);
// Given a directory/file wildcard (ie 'C:\temp\*.tmp'), delete all files matching that wildcard.
// This routine should be enhanced to cope with read-only files and directories,
// asking a "yes/no/yes to all" question
var
  Result: TSearchRec;
  iOK:    integer;
  sPath:  string;
  ilp:    integer;
  slDirs: TStringList;
begin
  //Because certain stupid languages can't delete wildcards, here's a function for it
  showhour;
  sPath := extractfilepath(sWildpath);
  iOK   := FindFirst(sWildpath, 0, Result);
  if iOK = 0 then
    begin
      repeat
        begin
          deletefile(filepath(sPath, Result.Name));
          iOK := FindNext(Result);
        end;
      until iOK <> 0;
    end;

  if bRecurse then
    begin
      slDirs := TStringList.Create;
      try
        slDirs.sorted := true;
        //now each sub dir
        GetSubDirs(sPath, slDirs, true);

        //Go reverse alphabetically so its easy to remove them
        for ilp := slDirs.Count - 1 downto 0 do
          begin
            DeleteDirFiles(filepath(slDirs[ilp], '*.*'), false);
            RemoveDir(slDirs[ilp]);
          end;
      finally
        slDirs.Free;
      end;
    end;
  hidehour;
end;

function LeftConTrim(sString, sTarget: string): string; //Left only
begin
  Result := sString;
  if comparetext(copy(sString, 0, length(sTarget)), sTarget) = 0 then
    begin
      delete(sString,1,length(sTarget)); //MidStr(sString, length(sTarget) + 1, );
      result := sString;
    end;
end;

function RightConTrim(sString, sTarget: string): string; //Trailing only
begin
  Result := sString;
  if comparetext(rightstr(sString, length(sTarget)), sTarget) = 0 then
    Result := copy(sString, 1, length(sString) - length(sTarget));
end;

function ConTrim(sString, sTarget: string): string; //Both
begin
  Result := rightcontrim(leftcontrim(sString, sTarget), sTarget);
end;

function AskYesNo(sQuestion: string): boolean;
// Puts up a Yes / No dialog. Returns true if Yes is chosen.
begin
  Result := ShowMessageBox(sQuestion, mtConfirmation, [mbYes, mbNo], 0) = mrYes;
end;

function AppDir: string;
// Returns directory of application.exename
begin
	//paramstr[0] is always the exe name, even in services.
  Result := extractfilepath(ParamStr(0));
end;

function IsFileReadOnly(sFile: string): boolean;
// Returns true if a file is read only.
var
  iAttr: integer;
begin
  Result := false;
  iAttr  := FileGetAttr(sFile);
  if iAttr > -1 then
    begin
      if (faReadOnly and iAttr) = faReadOnly then
        Result := true;
    end;
end;

function PosBig(sCulprit, sString: string): integer;
//This is the Boyer-Moore algorithm, as described in the Handbook of Algorithms
//and data structures.
//With short strings (less than ten characters) being searched for, its about the same
//speed as pos.  But as the target string (pat) gets longer, the algorithm kicks major
//booty.  Use it on longer strings.
var
  iTemp, i, j, k, m, n: integer;
  skip: array [0..255] of integer;
const
  MAXCHAR = 255;
begin
  Result := 0;
  m      := length(sCulprit);
  if m = 0 then
    begin
      Result := 1;
      exit;
    end;

  //Toonz optimizing tip - going down a for loop
  //is faster than going up if you're ending (or starting) at 0 (zero)
  for k := MAXCHAR downto 0 do
    skip[k] := m;                                //*** Preprocessing ***

  iTemp := m - 1;

  for k := 1 to iTemp do
    skip[Ord(sCulprit[k])] := m - k;

  k := m;
  n := length(sString) + 1;                      //*** Search ***
  while (k < n) do //<= n, remove the +1 above - bwian optimization
    begin
      i := k;
      j := m;
      while (j > 0) do // >= 1
        begin
          if sString[i] <> sCulprit[j] then
            break //j := -1
          else
            begin
              Dec(j);// := j-1;
              Dec(i);// := i-1;
            end;
        end;

      if j = 0 then
        begin
          Result := i + 1;
          break;
        end;

      k := k + skip[Ord(sString[k])];
    end;
end;

function ExecProgram(sEXE: string; sParameters: string = ''; iWindowMode: integer = SW_SHOWNA): integer;
// A simple wrapper around ShellExecute - tell Windows to open a file (ie a .txt file will open with Notepad).
// iWindow mode can be...
// SW_HIDE	Hides the window and activates another window.
// SW_MAXIMIZE	Maximizes the specified window.
// SW_MINIMIZE	Minimizes the specified window and activates the next top-level window in the Z order.
// SW_RESTORE	Activates and displays the window. If the window is minimized or maximized, Windows restores it to its original size and position. An application should specify this flag when restoring a minimized window.
// SW_SHOW	Activates the window and displays it in its current size and position.
// SW_SHOWDEFAULT	Sets the show state based on the SW_ flag specified in the STARTUPINFO structure passed to the CreateProcess function by the program that started the application. An application should call ShowWindow with this flag to set the initial show state of its main window.
// SW_SHOWMAXIMIZED	Activates the window and displays it as a maximized window.
// SW_SHOWMINIMIZED	Activates the window and displays it as a minimized window.
// SW_SHOWMINNOACTIVE	Displays the window as a minimized window. The active window remains active.
// SW_SHOWNA	Displays the window in its current state. The active window remains active.
// SW_SHOWNOACTIVATE	Displays a window in its most recent size and position. The active window remains active.
// SW_SHOWNORMAL	Activates and displays a window. If the window is minimized or maximized, Windows restores it to its original size and position. An application should specify this flag when displaying the window for the first time.
begin
  try
    Result := ShellExecute(application.handle, pchar('open'), pchar(
            sExe), pchar(sParameters), '', iWindowMode);
  except
    ShowMessage('An error occurred while trying to run ' + sExe);
    raise;
  end;
end;


function CopyDirTree(sWildPath, sDestRoot: string): integer;
//Mirror a directory tree to a new root location.
var
  slFiles:     TStringList;
  iDone, ilp:  integer;
  sDestFile:   string;
  sSourcePath: string;
  sWholeDestFile: string;
begin
  slFiles := TStringList.Create;
  Result  := -1;
  iDone   := 0;
  try
    sSourcePath := extractfilepath(sWildPath);
    ExpandWildcards(sWildPath, slFiles, true);
    for ilp := 0 to slFiles.Count - 1 do
      begin
        sDestFile      := ChopAfter(slFiles[ilp], sSourcePath, false);
        sWholeDestFile := filepath(sDestRoot, sDestFile);
        if not directoryexists(extractfilepath(sWholeDestFile)) then
          begin
            ForceDirectories(extractfilepath(sWholeDestFile));
            if not directoryexists(extractfilepath(sWholeDestFile)) then
              raise EDSSError.Create('Could not create directory ' +
                      extractfilepath(sWholeDestFile));
          end;

        if not copyfile(pchar(slFiles[ilp]), pchar(sWholeDestFile), false) then
          raise EDSSError.Create('Could not create file ' + sWholeDestFile)
        else
          Inc(iDone);
      end;
    Result := iDone;
  finally
    slFiles.Free;
  end;
end;

procedure SmartSave(sFile: string; cmp: TComponent; ssOptions: TSmartOptions;
    iMin, iMax: integer);
//BSMITH October 97
//cmp is usually the form on which all your saveable components live.
//For each component you want to be Saved/Loaded set its tag property to a unique, positive integer
//You'll be warned during saving if you've used the same number twice.
    function BuildListView(lv: TListView): string;
    var
      iSub, ilp: integer;
      sOut:      string;
    const
      DLSUB  = '^';
      DLLINE = '|';
    begin
      //Translate the contents of the listview into a single string
      sOut := '';
      for ilp := 0 to lv.items.Count - 1 do
        begin
          sOut := sOut + lv.Items[ilp].Caption + DLSUB;
          for iSub := 0 to lv.Items[ilp].subitems.Count - 1 do
            begin
              sOut := sOut + lv.Items[ilp].subitems[iSub] + DLSUB;
            end;
          sOut := rightcontrim(sOut, DLSUB);
          sOut := sOut + DLLINE;
        end;
      sOut   := rightcontrim(sOut, DLLINE);
      Result := sOut;
    end;

    function BuildStringGrid(aComp: TComponent): string;
    var
      sg: TStringGrid;
      iRow, iCol: integer;
    const
      DL = '|';
    begin
      sg := (aComp as TStringGrid);
      //We're going to return a string containing sg.colcount,sg.rowcount,sg.Cells[All of them]
      //using chr(2) as a seperator.  Can't use any of the usual delimiters because they're valid
      //characters.  Could use tab but that looks awful in saved files - too much space is easy
      //to screw up if you're tinkering with the saved file.

      //Includes the fixed rows/cols
      Result := IntToStr(sg.ColCount) + DL + IntToStr(sg.RowCount);

      for iRow := 0 to sg.rowcount - 1 do
        begin
          for iCol := 0 to sg.colcount - 1 do
            begin
              Result := Result + DL + sg.cells[iCol, iRow];
            end;
        end;
    end;

var
  //sContents : string;
  iCounter, iMinTag, iMaxTag, iTemp, ilp: integer;
  aComp: TComponent;
  sTemp, sTag, sTagsUsed: string;
  ini:   TINIFile;
  cl:    TCheckListBox;
const
  SSHEAD = 'Smart Save';
begin
  //This saves in a non-HTML format so people don't get confused
  //and try to install the save file on their server.
  if iMin = -1 then
    iMinTag := 1
  else
    iMinTag := iMin;

  if iMax = -1 then
    iMaxTag := 9999999
  else
    iMaxTag := iMax;

  showhour;
  ini := TINIFile.Create(sFile);
  ini.EraseSection(SSHEAD);
  try
    sTagsUsed := ',';
    for ilp := 0 to cmp.componentcount - 1 do
      begin
        aComp := cmp.Components[ilp];
        if (aComp.tag >= iMinTag) and (aComp.tag <= iMaxTag) then
          begin
            sTag := IntToStr(aComp.tag);
            //sOut := sOut + '[' + sTag +'=';
            if pos(',' + sTag + ',', sTagsUsed) > 0 then
              ShowMessage(
                      'Internal error : The SmartSave routine has found two controls with the same Tag (' +
                      sTag + ').  One of them is ' + aComp.Name);

            sTagsUsed := sTagsUsed + sTag + ',';

            if aComp is TEdit then
              ini.writestring(SSHEAD, sTag, TEdit(aComp).Text)
            else if aComp is TMemo then
              begin
                sTemp := TMemo(aComp).Text;
                if TMemo(aComp).WantReturns then
                  sTemp := StringReplace(sTemp, crlf, '_CR_', [rfReplaceAll, rfIgnoreCase]);
                  ini.writestring(SSHEAD, sTag, sTemp);
              end
            else if aComp is TLabel then
              ini.writestring(SSHEAD, sTag, TLabel(aComp).Caption)
            else if aComp is TCheckBox then
              ini.writestring(SSHEAD, sTag, BoolToTF(TCheckBox(aComp).Checked))
            else if aComp is TRadioButton then
              ini.writestring(SSHEAD, sTag, BoolToTF(TRadioButton(aComp).Checked))
            else if aComp is TCheckListBox then
              begin
                sTemp := '';
                cl    := TCheckListBox(aComp);
                for iCounter := 0 to TCheckListBox(aComp).Items.Count - 1 do
                  begin
                    sTemp := sTemp + IntToStr(iCounter) + '=' + BoolToTF(cl.Checked[iCounter]) + ',';
                  end;
                stemp := rightcontrim(sTemp, ',');
                ini.writestring(SSHEAD, sTag, sTemp);
              end
            else if (aComp is TListBox) or (aComp is TComboBox) then
              begin
                iTemp := TListBox(aComp).ItemIndex;
                if iTemp > -1 then
                  ini.writestring(SSHEAD, sTag, TListBox(aComp).items[iTemp]);

                if ssoSaveListContents in ssOptions then
                  ini.writestring(SSHEAD, sTag, '|' + TListBox(aComp).items.CommaText);
              end
            else if aComp is TListView then
              ini.writestring(SSHEAD, sTag, BuildListView(TListView(aComp)))
            else if aComp is TRadioGroup then
              ini.writestring(SSHEAD, sTag, IntToStr(TRadioGroup(aComp).ItemIndex))
            else if aComp is TStringGrid then
              ini.writestring(SSHEAD, sTag, BuildStringGrid(aComp))
//          else if aComp is TSpinEdit then
//            ini.writestring(SSHEAD, sTag, IntToStr(TSpinEdit(aComp).Value))
            else
              ShowMessage('Internal error! Tried to SmartSave an unrecognized object type : ' + aComp.Name);
              //sOut := sOut + ']'+ crlf;
          end;
      end;
  finally
    ini.Free;
  end;
  hidehour;
end;

function SmartLoad(sFile: string; cmp: TComponent; slOptions: TSmartOptions;
    iMin, iMax: integer): boolean;
//cmp is usually the form on which all your saveable/loadable components live.
//For each component you want to be Saved/Loaded set its tag property to a unique, positive integer
//You'll be warned during saving if you've used the same number twice.
    procedure LoadCheckListBox(cl: TCheckListBox; sData: string);
    var
      iclCount: integer;
      sl:     TStringList;
      sValue: string;
    begin
      sl := TStringList.Create;
      try
        ParseLine(sData, ',', sl);
        for iclCount := 0 to sl.Count - 1 do
          begin
            sValue := chopafter(sl[iclCount], '=', false);
            cl.Checked[iclCount] := IsTrue(sValue);
          end;
      finally
        sl.Free;
      end;
    end;

    procedure LoadListView(lv: TListView; sData: string);
    var
      iSub, iLine: integer;
      slCols, slLines: TStringList;
      oItem: TListItem;
    const
      DLSUB  = '^';
      DLLINE = '|';
    begin
      //Translate the contents of the listview into a single string
      slLines := TStringList.Create;
      slCols  := TStringList.Create;
      lv.Items.Clear;
      try
        ParseLine(sData, DLLINE, slLines);
        for iLine := 0 to slLines.Count - 1 do
          begin
            oItem := lv.items.add;
            ParseLine(slLines[iLine], DLSUB, slCols);
            oItem.Caption := slCols[0];
            //for iSub := 1 to slCols.count-1 do
            for iSub := 1 to lv.Columns.Count do
              begin
                //Fill out the number of columns
                if iSub <= (slCols.Count - 1) then
                  oItem.subitems.add(slCols[iSub])
                else
                  oItem.subitems.add('');
              end;
          end;
      finally
        slLines.Free;
        slCols.Free;
      end;
    end;

    function LoadStringGrid(aComp: TComponent; sData: string): string;
    var
      sg:     TStringGrid;
      iRow, iCol, iIndex, iMaxRow, iMaxCol: integer;
      slData: TStringList;
    const
      DL = #2;
    begin
      //We're going to read a string containing sg.colcount,sg.rowcount,sg.Cells[All of them]
      //using chr(2) as a seperator.  Can't use any of the usual delimiters because they're valid
      //characters.  Could use tab but that looks awful in saved files - too much space is easy
      //to screw up if you're tinkering with the saved file.

      //Includes the fixed rows/cols
      sg     := (aComp as TStringGrid);
      slData := TStringList.Create;
      try
        if ParseLine(sData, DL, slData) > 2 then
          begin
            try
              iMaxCol     := StrToInt(slData[0]);
              iMaxRow     := StrToInt(slData[1]);
              sg.RowCount := iMaxRow;
              sg.ColCount := iMaxCol;

              for iIndex := 2 to slData.Count - 1 do
                begin
                  iCol := iIndex mod iMaxCol;
                  iRow := (iIndex - 2) div iMaxCol;
                  sg.Cells[iCol, iRow] := slData[iIndex];
                end;
            except
              raise Exception.Create(
                        'Corrupted information found in StringGrid data in SmartSaved file.  Cannot SmartLoad this file.');
            end;
          end;

      finally
        slData.Free;
      end;
    end;

var
  iMinTag, iMaxTag, ilp: integer;
  aComp: TComponent;
  sTag:  string;
  ini:   TINIFile;
const
  SSHEAD = 'Smart Save';
begin
  if iMin = -1 then
    iMinTag := 1
  else
    iMinTag := iMin;

  if iMax = -1 then
    iMaxTag := 9999999
  else
    iMaxTag := iMax;

  Result := true;
  if fileexists(sFile) then
    begin
      ini := TINIFile.Create(sFile);
      try
        try
          for ilp := 0 to cmp.componentcount - 1 do
            begin
              aComp := cmp.Components[ilp];
              if (aComp.tag >= iMinTag) and (aComp.tag <= iMaxTag) then
                begin
                  sTag := IntToStr(aComp.tag);
                  if aComp is TEdit then
                    TEdit(aComp).Text := ini.readstring(SSHEAD, sTag, '')
                  else if aComp is TMemo then
                    begin
                      if TMemo(aComp).WantReturns then
                        TMemo(aComp).Text := StringReplace(ini.readstring(SSHEAD, sTag, ''), '_CR_', crlf, [rfReplaceAll, rfIgnoreCase])
                      else
                        TMemo(aComp).Text := ini.readstring(SSHEAD, sTag, '');
                    end
                  else if aComp is TLabel then
                    TLabel(aComp).Caption := ini.readstring(SSHEAD, sTag, '')
                  else if aComp is TCheckBox then
                    TCheckBox(aComp).Checked := IsTrue(ini.readstring(SSHEAD, sTag, ''))
                  else if (aComp is TListBox) or (aComp is TComboBox) then
                    begin
                      if ssoSaveListContents in slOptions then
                        begin
                          //selected value,item1,item2...itemn
                          TListBox(aComp).items.commatext := chopafter(ini.readstring(SSHEAD, sTag, ''), '|', true);
                          TListBox(aComp).ItemIndex :=
                              TListBox(aComp).items.indexof(chopbefore(ini.readstring(SSHEAD, sTag, ''), '|', false));
                        end
                      else
                        TListBox(aComp).ItemIndex := TListBox(aComp).Items.IndexOf(ini.readstring(SSHEAD, sTag, ''));
 //Safestrtoint(GSV(sText,sTag),-1)
                    end
                  else if aComp is TCheckListBox then
                    LoadCheckListBox(TCheckListBox(aComp), ini.readstring(SSHEAD, sTag, ''))
                  else if aComp is TListView then
                    LoadListView(TListView(aComp), ini.readstring(SSHEAD, sTag, ''))
                  else if aComp is TRadioButton then
                    TRadioButton(aComp).Checked := IsTrue(ini.readstring(SSHEAD, sTag, ''))
                  else if aComp is TRadioGroup then
                    TRadioGroup(aComp).ItemIndex := strtointdef(ini.readstring(SSHEAD, sTag, ''), -1)
//                else if aComp is TSpinEdit then
//                  TSpinEdit(aComp).Value := strtointdef(ini.readstring(SSHEAD, sTag, '0'), 0)
                  else if aComp is TStringGrid then
                    LoadStringGrid(aComp, ini.readstring(SSHEAD, sTag, ''))
                  else
                    ShowMessage('Internal error! Tried to SmartLoad an unrecognized object type :' + aComp.Name);
                end;
            end;
          except
            on e: Exception do
              begin
                raise Exception.Create('SmartLoad failed to load ' + sFile + crlf +
                      crlf + e.message);
              end;
          end;
      finally
        ini.Free;
      end;
    end
  else
    Result := false;
end;

procedure SmartClear(cmp: TComponent; scoOptions: TSmartClearOptions);
//Clear everything
//Deliberately doesn't clear TLabels, since they're rarely needed to be cleared
//and its more useful for this routine to be able to clear everything regardless
//of whether its Tag is > 0.
var
  ilp:   integer;
  aComp: TComponent;
begin
  for ilp := 0 to cmp.ComponentCount - 1 do
    begin
      aComp := cmp.Components[ilp];
      //If doing ALL components there's still a way to protect components
      //If tag < 0 then it won't be cleared
      if (aComp.tag > 0) or ((scoClearAllComponents in scoOptions) and
         (aComp.Tag >= 0)) then
        begin
          if aComp is TEdit then
            TEdit(aComp).Text := ''
          else if aComp is TCheckBox then
            TCheckBox(aComp).Checked := false
          else if aComp is TStringGrid then
            ClearGrid(TStringGrid(aComp), true)
          else if aComp is TRadioButton then
            TRadioButton(aComp).Checked := false
          else if aComp is TMemo then
            TMemo(aComp).Text := ''
          else if aComp is TListBox then
            begin
              if scoClearLists in scoOptions then
                TListBox(aComp).items.Clear
              else
                TListBox(aComp).ItemIndex := -1;
            end
          else if aComp is TComboBox then
            begin
              TComboBox(aComp).ItemIndex := -1;
            end
          else if aComp is TRadioGroup then
            TRadioGroup(aComp).ItemIndex := -1
          //How about objects that can have their own components in them ?
          else if aComp is TGroupBox then
            SmartClear(aComp, scoOptions)
          else                //Don't report if we were asked to clear all
            //Almost certain to find a component not listed above
            if not (scoClearAllComponents in scoOptions) then
              ShowMessage('Internal error! Tried to SmartClear an unrecognized object type : ' + aComp.Name);
        end;
    end;
end;

procedure ClearGrid(sg: TStringGrid; bClearFixed: boolean);
// Since TStringGrids don't have a .Clear method, here's one.
// If bClearFixed is true it will also clear the contents of the fixed "header" columns.
var
  iStartRow, iStartCol, iRow, iCol: integer;
begin
  if bClearFixed then
    begin
      iStartRow := 0;
      iStartCol := 0;
    end
  else
    begin
      iStartRow := sg.FixedRows;
      iStartCol := sg.FixedCols;
    end;

  for iRow := iStartRow to sg.RowCount - 1 do
    begin
      for iCol := iStartCol to sg.ColCount - 1 do
        begin
          sg.Cells[iCol, iRow] := '';
        end;
    end;
end;
(* Moved to uDSSPiece
function Piece(sSource, sDelimiter: string; iPiece: integer): string;
//BSMITH march 2002
//This is a DSS function, but it could be replaced by calling
//ParseLine and getting the iPiece-th item in the resulting
//stringlist, but this isn't necessary unless we're getting ultra-efficient and
//wanting to reduce source code size.
//
//I've tested this for robustness and it is ok, except in the following
//case: If you pass, say 1--2--3--4--- using "--" as the delimiter and ask for the
//fifth item in the list, you'd expect "-" as a result, but you actually get nothing.
//This is minor, since it involves only sDelimiters with length >= 2, something we're not
//doing at DSS.
var
  delIndex, pieceNumber, startScanIndex, firstCharIndex: integer;
begin
  startScanIndex := 1;
  pieceNumber    := 0;
  firstCharIndex := 0;
  repeat
    delIndex := Pos(sDelimiter, Copy(sSource + sDelimiter, startScanIndex, length(sSource)));
    if delIndex > 0 then
      begin
        Inc(pieceNumber);
        firstCharIndex := startScanIndex;
        startScanIndex := startScanIndex + delIndex + Length(sDelimiter) - 1;
      end;
  until (pieceNumber = iPiece) or (delIndex = 0);
  if delIndex > 0 then
    Result := Copy(sSource, firstCharIndex, delIndex - 1)
  else if (pieceNumber > 0) or (iPiece > 1) then
    Result := ''
  else
    Result := sSource;
end;
*)
function DirPathFix(const ADirPath: string): string;
//Puts a trailing '\' after ADirPath if there isn't one there
//Written by Xavier Pacheco
//Formerly in TrmReportFuncs--it was the only thing there,
//so I moved it here: it's useful in any program
begin
  if ADirPath[Length(ADirPath)] <> '\' then
    Result := ADirPath + '\'
  else
    Result := ADirPath;
end;

procedure AppendToFile(sFile, sLine: string);
//Add sLine to the contents of file sFile. If sFile doesn't exist it will be created.
var
  tfFile: TextFile;
begin
  if not fileexists(sFile) then
    WriteWholeFile(sFile, '');

  AssignFile(tfFile, sFile);
  try
    Append(tfFile);
    WriteLn(tfFile, sLine);
  finally
    CloseFile(tfFile);
  end;
end;

procedure SetFocusInPageControl(ctlControl: TWinControl);
// When validating user input into a wizard or some other TPageControl, you'll find
// that you can't .SetFocus to a particular control if sits on a TTabSheet that is
// NOT the current .ActivePage. This function will find the parent page for any control
// you choose and switch to that page before doing a SetFocus on the control you wanted.
var
  pgParent:      TTabSheet;
  pcPagecontrol: TPageControl;
  ctlTestParent: TControl;
begin
  pgParent := nil;
  if ctlControl.Parent is TTabSheet then
    pgParent := TTabSheet(ctlControl.Parent)
  else
    begin
    	//Start by pointing to the parent of the passed control
      ctlTestParent := ctlControl.parent;
      while pgParent = nil do
        begin
          if ctlTestParent.HasParent then
            ctlTestParent := ctlTestParent.parent
          else
            break;
          if ctlTestParent is TTabSheet then
            pgParent := TTabSheet(ctlTestParent)
        end;
    end;

  if pgParent <> nil then
    begin
      pcPageControl := TPageControl(pgParent.parent);
      pcPagecontrol.ActivePage := pgParent;
      ctlControl.SetFocus;
    end
  else
    //do not remove this handler
{$IFDEF DEBUG}
  raise Exception.create('SetFocusInPageControl:targetted control''s ('+ctlControl.name+') does not have a TTabSheet in its parentage.');
{$ENDIF}
end;
(*
function VistaPiece(sSource: string; iPiece: integer): string;
begin
  //Calls the Piece function and fills in the second parameter for you.
  Result := Piece(sSource, VISTADELIMITER, iPiece);
end;
*)
function MyGetUserName: string;
// Returns the name of the user logged in to Windows.
var
  lpBuffer: lpstr;
  success:  boolean;
  nSize:    DWord;
begin
  nSize  := 255;
  Result := '';
  GetMem(lpBuffer, 255);
  try
    success := GetUserName(lpBuffer, nSize);
    if not success then
      Result := 'Unknown NT User'
     else
      Result := StrPas(lpBuffer);
  finally
    FreeMem(lpBuffer);
  end;
end;

function MyGetComputerName: string;
// Gets the name of the computer
var
  lpBuffer: lpstr;
  success:  boolean;
  nSize:    DWord;
begin
  nSize  := 255;
  Result := '';
  GetMem(lpBuffer, 255);
  try
    success := GetComputerName(lpBuffer, nSize);
    if not success then
      Result := 'Unknown'
    else
      Result := StrPas(lpBuffer);
  finally
    FreeMem(lpBuffer);
  end;
end;

function CountWildcard(sWildcard: string; bRecurse: boolean = false): integer;
// Given a directory/file wildcard (ie 'C:\temp\*.tmp'), count how many files match that wildcard.
var
  slFiles: TStringList;
begin
  slFiles := TStringList.Create;
  try
    ExpandWildcards(sWildcard, slFiles, bRecurse);
    Result := slFiles.Count;
  finally
    slFiles.Free;
  end;
end;

function GetSystemPath: string;
var
  sBuffer:   pchar;
  iSize:     integer;
  sTempPath: string;
begin
  Result  := '';
  sBuffer := StrAlloc(256);
  iSize   := GetSystemDirectory(sBuffer, 255);
  if iSize > 0 then
    begin
      sTempPath := copy(sBuffer, 1, iSize);
      Result    := sTempPath;
    end;
  StrDispose(sBuffer);
end;

function GetWindowsPath: string;
var
  sBuffer:   pchar;
  iSize:     integer;
  sTempPath: string;
begin
  Result  := '';
  sBuffer := StrAlloc(256);
  iSize   := GetWindowsDirectory(sBuffer, 255);
  if iSize > 0 then
    begin
      sTempPath := copy(sBuffer, 1, iSize);
      Result    := sTempPath;
    end;
  StrDispose(sBuffer);
end;

procedure SetAllListViewColumnsToMaxWidth(lvListView: TListView; bFitHeader: boolean = false);
//Set the width of each column to the width of their widest item
//
//NOTE - AFTER THIS IS APPLIED TO A LISTVIEW IT WILL BE **VERY** SLOW
//TO ADD NEW ITEMS TO THE LIST. It's about 15-20 times slower on my box.
//Ideally you would call SetAllListViewColumnsToFixedWidth before loading
//lots of new rows into a TListView that had been MaxWidthed.
//
//Begin|EndUpdate doesn't help either - you really need to set the col widths
//back to fixed.
var
  iRowLP,ilp:  integer;
  iHeaderWidth,iValueWidth,iWidthToUse,iVal: integer;
  sValue:string;
begin
  iVal := -1;
  //Columns should fit the widest value in the actual rows
  //But columns should match the width of the column header if asked to do so,
  //or if there are no rows in the whole listview
  if bFitHeader or (lvListView.Items.Count = 0) then
    iVal := -2;

  for ilp := 0 to lvListView.Columns.Count - 1 do
    begin
      lvListView.Columns[ilp].Width := iVal;
    end;

  //If any of the columns contain no data, set the column width to -2 (width of header)
  //Also if none of the data shown is wider than the column header, use the col header width
  for ilp := 0 to lvListView.Columns.Count - 1 do
    begin
      //Look at each item in this column

      iWidthToUse := -2;//default to using the "match header" width setting
      //How wide is the header, in pixels ?
      iHeaderWidth := lvListView.Canvas.TextWidth(lvListView.Columns[ilp].caption);
      for iRowLP := 0 to lvListView.Items.count-1 do
        begin
          if ilp = 0 then
            svalue := lvListView.items[iRowlp].caption
          else
            begin
              //If there's a subitem we can read, get it
              //otherwise, there's no value there - use ''
              if lvListView.items[iRowlp].subitems.count >= ilp then
                sValue := lvListView.items[iRowlp].subitems[ilp-1]
              else
                sValue := '';
            end;

          if sValue <> '' then
            begin
              iValueWidth := lvListView.Canvas.TextWidth(sValue);
              if iValueWidth > iHeaderWidth then
                begin
                  iWidthTouse := -1; //We found something - use "match column contents width" setting.
                  break; //We can break now...we've cleared the threshold of being wider than the header width
                         //listview will choose its own width.
                end;
            end;
        end;
      lvListView.Columns[ilp].Width := iWidthToUse;
    end;
end;

procedure SetAllListViewColumnsToFixedWidth(lvListView: TListView;iWidth:integer=50);
var
  ilp:  integer;
begin
  //No, using Items.Begin/EndUpdate does NOT do the same thing as this.
  for ilp := 0 to lvListView.Columns.Count - 1 do
    begin
      lvListView.Columns[ilp].Width := iWidth;
    end;
end;

function SortListView(Item1, Item2: TListItem; bSortAscending: boolean;
                iColumnIndex: integer; iSortType: integer = 0): integer;
var
  scompare1, sCompare2: string;
  iVal1, iVal2:     integer;
  fVal1, fVal2:     double;
  dtDate1, dtDate2: TDateTime;
begin
  //got sick of writing this individually, so this routine will handle any list view

  //[STEP ONE]
  //In your TListView.OnCompare event, do
  //      Compare := SortListView(Item1,Item2,Data,[0|1|2])
  //Decide for yourself if you want the data to be compared by integer or not
  //Obviously, don't pick a column with alphabetic data and tell me it's an
  //integer sort though !

  //STEP TWO
    //If you want bi-directional sorting you'll need to put a few things in place.
    //declare these two:
    //    bSortAscending:boolean; //We use this to track the sort order for the listview
    //  iLastColumnSorted:integer;//ditto

    //In form.create initialize them to TRUE and -1 respectively.

    //STEP THREE
    //then your listview.columnclick should look like this
{    if Column.Index = iLastColumnSorted then
        bSortAscending := not bSortAscending
    else
        bSortAscending := true;

    iLastColumnSorted := Column.Index;

    lvLinks.CustomSort(nil,Column.Index);
 }

 // It's a pain that we have to track this ourselves: The listview in QComCtrls seems
 //much nicer, with built-in properties for this kind of stuff.
 // If this doesn't suit your needs, look for a third party listview control
 //or try and figure out how to use the qcomctrls listview instead of the standard one.

  //First lets extract the data we'll be comparing.  It might be in the
  //.caption, or a subitem.
  if iColumnIndex = 0 then
    begin
      sCompare1 := Item1.Caption;
      sCompare2 := Item2.Caption;
    end
  else
    begin
      sCompare1 := Item1.subitems[iColumnIndex - 1];
      sCompare2 := Item2.subitems[iColumnIndex - 1];
    end;
  //Handle "long" dates too, i.e Jun 25, 1999
  if (iSortType = 2) and (pos(',',sCompare1) > 0) then
    sCompare1 := LongDateStringToNumericDateString(sCompare1);
  if (iSortType = 2) and (pos(',',sCompare2) > 0) then
    sCompare2 := LongDateStringToNumericDateString(sCompare2);

  //Now do the comparison either as string, integer, float, date
  case iSortType of
    0: Result := AnsiCompareText(sCompare1, sCompare2);
    1: //integer
        begin
          //Use the safe version of strtoint
          iVal1 := strtointdef(sCompare1, 0);
          iVal2 := strtointdef(sCompare2, 0);
          result := CompareValue(iVal1,iVAl2);
        end;
    2: //date
        begin
          dtDate1 := StrToDateDef(sCompare1,0);
          dtDate2 := strtodatedef(sCompare2,0);
          Result := CompareDate(dtDate1,dtDate2);
        end;
    3: //float
        begin
          //Use the safe version of strtoint
          fVal1 := StrToFloatDef(sCompare1, 0);
          fVal2 := StrToFloatDef(sCompare2, 0);
          result := CompareValue(fVal1,fVal2);
        end;
    4: //datetime
        begin
          dtDate1 := StrToDateTimeDef(sCompare1,0);
          dtDate2 := StrToDateTimeDef(sCompare2,0);
          Result := CompareDateTime(dtDate1,dtDate2);
        end;
    5: //Vista Date Time, long format
        begin
            dtDate1 := FMLongDateToTDateTime(sCompare1);
            dtDate2 := FMLongDateToTDateTime(sCompare2);
            Result := CompareDateTime(dtDate1,dtDate2);
        end;
    else
      Result := 0;
  end;

  if not bSortAscending then
    Result := -(Result);
end;

procedure EnableChildren(cnt: TWinControl; bEnabled: boolean);
//Brian Smith
// This will enable or disable all the "child" controls inside a particular Delphi
// windows control.  Best used with Panels, GroupBoxes etc. It will recurse through
// any child controls which could contain other controls. Very handy for enabling/disabling
// groups of controls that the user should or shouldn't have access to dynamically at
// runtime with just a single line of code.
var
  ilp: integer;
begin
  for ilp := 0 to cnt.ControlCount - 1 do
    begin
      try
        if cnt.Controls[ilp] is TWinControl then
          begin
            if TWinControl(cnt.Controls[ilp]).ControlCount > 0 then
              EnableChildren(TWinControl(cnt.Controls[ilp]), bEnabled);
          end;

        if cnt.Controls[ilp] is TControl then
          cnt.Controls[ilp].Enabled := bEnabled;
      except
        //Ignore errors - it just means it wasn't worth checking if the
        //object had .Controls of its own
      end;
    end;
end;

procedure DeleteFiles(slFiles: TStringList);
// Delete all files listed in a TStringList where each line contains a file's full pathname.
// Use with ExpandWildcard if you want to build a list of files that match
// a wildcard (ie *.tmp)
var
  ilp: integer;
begin
  for ilp := 0 to slFiles.Count - 1 do
    begin
      deletefile(slFiles[ilp]);
    end;
end;

function GetVersionInfo(var VersionInfo: TFileVersion; sEXEFile: string = ''): boolean;
// Populates a TFileVersion structure (also defined in this unit) with version info
// about any .exe. If none is specified then it returns data about the current executable.
var
  InfoSize {,} : UINT;
  Wnd: DWORD;
  VerBuf:  Pointer;
  FI:      PVSFixedFileInfo;
  VerSize: DWORD;
begin
  FI     := nil;
  Result := false;
  if sEXEFile = '' then
    sEXEfile := application.exename;

  InfoSize := GetFileVersionInfoSize(pchar(sEXEFile), Wnd);
  if InfoSize <> 0 then
    begin
      GetMem(VerBuf, InfoSize);
      try
        try
          begin
            if GetFileVersionInfo(pchar(sEXEfile), Wnd, InfoSize, VerBuf) then
              begin
                if VerQueryValue(VerBuf, '\', Pointer(FI), VerSize) then
                  begin
                    VersionInfo.Major := FI.dwFileVersionMS shr 16;
                    VersionInfo.Minor := FI.dwFileVersionMS and $FFFF;  {!!2.2}
                    VersionInfo.Release := FI.dwFileVersionLS shr 16;
                    VersionInfo.Build := FI.dwFileVersionLS and $FFFF;  {!!2.2}
                    Result := true;
                  end;
              end;
          end;
        except
          on E: Exception do
            begin
              // WriteToLog( E.Message )
            end;
        end;
      finally
        FreeMem(VerBuf);
      end;
    end;
end;

function GetVersionInfoStr( sEXEFile: string = ''): string;
//!!2.1 Returns the version info of sEXEFile in string format about any .exe.
// If none is specified then it returns data about the current executable.
var
  ExeInfo : TFileVersion;
begin
  if GetVersionInfo( ExeInfo , sEXEFile ) = TRUE then
    begin
      Result := IntToStr(ExeInfo.Major) + '.' + IntToStr(ExeInfo.Minor) + '.'
                + IntToStr(ExeInfo.Release) + '.' + IntToStr(ExeInfo.Build);
    end
  else
    Result := 'UNKNOWN';
end;

function ProperCase(s: string): string;
// Attemps to capitalize the first letter of each word in string s.
var
  CurPos, StrLen:     integer;
  ThisChar, LastChar: char;
const
  WhiteSpace = [chr(0)..chr(32)];
  Caps = ['A'..'Z'];
  Lows = ['a'..'z'];
begin
  StrLen   := Length(s);
  ThisChar := chr(32);
  LastChar := ThisChar;
  CurPos   := 0;
  while CurPos < StrLen do
    begin
      Inc(CurPos);
      ThisChar := s[CurPos];
      if (LastChar in WhiteSpace) and (ThisChar in Lows) then
        s[CurPos] := UpCase(ThisChar)
      else if not (LastChar in WhiteSpace) and (ThisChar in Caps) then
        s[CurPos] := Chr(Ord(ThisChar) + 32);
      LastChar := ThisChar;
    end;
  Result := s;
end;

function RemoveTrailing(sWhole, sToRemove: string): string;
var
  iTargetLen: integer;
begin
  iTargetLen := length(sToRemove);
  assert(iTargetLen > 0);

  while rightstr(sWhole, iTargetLen) = sToRemove do
    begin
      Delete(sWhole, length(sWhole) - (iTargetLen) + 1, iTargetLen);
    end;
  Result := sWhole;
end;

function GetCommandLineValueByName(sName: string): string;
//DO NOT PUT A LEADING SLASH (/) IN THE PASSED PARAM !!
//It gets trimmed out of the CLPs we're checking, and you won't get a match
//for command line variables passed in the following format
//    /name=value (well, the slash doesn't have to be there)
//will return "value" for a particular "name"
var
  ilp: integer;
  sThisName, sThisValue: string;
begin
  result := ''; //default to blank
  //Don't check param(0) - it's the name of the .exe we're running
  for ilp := 1 to ParamCount do
    begin
      if pos('=', ParamStr(ilp)) > 0 then
        begin
          sThisName  := chopbefore(ParamStr(ilp), '=', false);
          sThisName := leftcontrim(sThisName,'/');
          sThisValue := chopafter(ParamStr(ilp), '=', false);
          if sametext(sThisName, sName) then
            begin
              Result := sThisValue;
              break;
            end;
        end;
    end;
end;

function ROT13(sString: string): string;
//Simple keyless encryption function
//maps a->m to n->z and vice-versa
var
  iTemp, ilp: integer;
  sTest:      string;
begin
  setlength(Result, length(sString));
  for ilp := 1 to length(sString) do
    begin
      sTest := lowercase(sString[ilp]);
      if (sTest >= 'a') and (sTest <= 'm') then
        begin
          iTemp := Ord(sTest[1]) + 13;
          Result[ilp] := chr(iTemp)
        end
      else
        begin
          iTemp := Ord(sTest[1]) - 13;
          Result[ilp] := chr(iTemp)
        end;
    end;
end;
                                                                    
function MyWrapText(const Line, BreakStr: string; const BreakChars: TSysCharSet;
    MaxCol: integer; bEnforceMaxCol: boolean): string;
// Brian Smith
// MyWrapText allows you to wrap a given string at any width you want, specifying any
// Break Characters (ie "where to wrap") you wish. An overloaded version is provided
// to use sensible defaults.  Based on Delphi's WrapText command which has a problem with quotes.
const
  // WrapText
  //QuoteChars = ['''', '"'];
  QuoteChars = [];
var
  Col, Pos: integer;
  LinePos, LineLen: integer;
  BreakLen, BreakPos: integer;
  QuoteChar, CurChar: char;
  ExistingBreak: boolean;
  L:   integer;
  //BSMITH
  slEnforce: TStringList;
  ilp: integer;
  sRemnant: string;
  bOKToInsert: boolean;
begin
  if MaxCol < 1 then
    MaxCol := 1;
  Col := 1;
  Pos      := 1;
  LinePos  := 1;
  BreakPos := 0;
  QuoteChar := #0;
  ExistingBreak := false;
  LineLen  := Length(Line);
  BreakLen := Length(BreakStr);
  Result   := '';
  while Pos <= LineLen do
    begin
      CurChar := Line[Pos];
      if CurChar in LeadBytes then
        begin
          L := CharLength(Line, Pos) - 1;
          Inc(Pos, L);
          Inc(Col, L);
        end
      else
        begin
          if CurChar in QuoteChars then
            if QuoteChar = #0 then
              QuoteChar := CurChar
            else if CurChar = QuoteChar then
              QuoteChar := #0;
          if QuoteChar = #0 then
            begin
              if CurChar = BreakStr[1] then
                begin
                  ExistingBreak := StrLComp(Pointer(BreakStr), Pointer( @Line[Pos]),
                        BreakLen) = 0;
                  if ExistingBreak then
                    begin
                      Inc(Pos, BreakLen - 1);
                      BreakPos := Pos;
                    end;
                end;

              if not ExistingBreak then
                if CurChar in BreakChars then
                  BreakPos := Pos;
            end;
        end;

      Inc(Pos);
      Inc(Col);

      if not (QuoteChar in QuoteChars) and (ExistingBreak or
            ((Col > MaxCol) and (BreakPos > LinePos))) then
        begin
          Col    := 1;
          Result := Result + Copy(Line, LinePos, BreakPos - LinePos + 1);
          if not (CurChar in QuoteChars) then
            begin
              while Pos <= LineLen do
                begin
                  if Line[Pos] in BreakChars then
                    begin
                      Inc(Pos);
                      ExistingBreak := false;
                    end
                  else
                    begin
                      ExistingBreak := StrLComp(Pointer( @Line[Pos]), sLineBreak,
                          Length(sLineBreak)) = 0;
                      if ExistingBreak then
                        Inc(Pos, Length(sLineBreak))
                      else
                        Break;
                    end;
                end;
            end;
          if (Pos <= LineLen) and not ExistingBreak then
            Result := Result + BreakStr;

          Inc(BreakPos);
          LinePos := BreakPos;
          Pos     := LinePos;
          ExistingBreak := false;
        end;
    end;
  Result := Result + Copy(Line, LinePos, MaxInt);

  Result := stringreplace(Result, crlf + crlf, crlf, [rfReplaceAll]);
  //BSMITH OCT 2003
  //If no spaces,tabs etc are found and this flag is set then FORCE
  //each line to be less than MaxCol characters long.
  if bEnforceMaxCol then
    begin
      slEnforce := TStringList.Create;
      try
        ParseLine(Result, BreakStr, slEnforce);
        ilp := 0;
        while ilp <= slEnforce.Count - 1 do
          begin
            if length(slEnforce[ilp]) > MaxCol then
              begin
                //Create a new line with the "remnant" of the line
                //Note that it may be longer than MaxCol characters, but don't worry
                //the do-while loop will hit it next and trim it too.  A for-while
                //loop would not have done so because the loop condition would
                //not be re-evaluated each time through (ie it doesn't "notice"
                //the new lines created by the .Insert command below.
                sRemnant    := copy(slEnforce[ilp], MaxCol + 1, MAXINT);
                bOKToInsert := true;
                //Look for a case where there's a space, then a word AFTER
                //a word that was long enough to fill an entire line and need wrapping
                //This section says "make sure we don't insert a line that only contains
                //a break character such as a space"
                if length(sRemnant) = 1 then
                  begin
                    Curchar := sRemnant[1];
                    if CurChar in BreakChars then
                      bOKToInsert := false;
                  end;
                if bOKToInsert then
                  slEnforce.Insert(ilp + 1, sRemnant);
                //Now trim the line down to MaxCol size
                slEnforce[ilp] := copy(slEnforce[ilp], 0, MaxCol);
              end;
            Inc(ilp);
          end;
        Result := slEnforce.Text;

        //Last check for length - the exception should never be reached but it is VERY
        //important that this routine not have let anything go past MaxCol.
        if bEnforceMaxCol then
          begin
            for ilp := 0 to slEnforce.Count - 1 do
              begin
                if length(slEnforce[ilp]) > MaxCol then
                  raise Exception.Create(
                        'The MyWrapText function has allowed a line longer than ' + IntToStr(MaxCol) + ' characters to be formatted.  That line is ' + crlf + crlf
                        + slEnforce[ilp]);

              end;
          end;
      finally
        slEnforce.Free;
      end;
    end;
end;

function MyWrapText(const Line: string; MaxCol: integer=80; bEnforceMaxCol: boolean = true): string;
begin
  //Call MyWrapText with the most sensible options for the BreakStr and CharSet of breakpoints
  Result := MyWrapText(Line, crlf, ['.',' ', '-', #9], MaxCol, bEnforceMaxCol);
 { do not localize }
end;

function CountCheckListChecked(chklst: TCheckListBox): integer;
// Given a TCheckListBox, count how many of its .Items are .Checked.
var
  ilp: integer;
begin
  Result := 0;
  for ilp := 0 to chklst.Items.Count - 1 do
    begin
      if chklst.Checked[ilp] then
        Inc(Result);
    end;
end;

procedure SetCheckListAllChecked(chklst: TCheckListBox; bChecked: boolean);
// When a "check all" option is chosen, you want your TCheckListBox to have all possible choices checked
var
  ilp: integer;
begin
  for ilp := 0 to chklst.Items.Count - 1 do
    chklst.Checked[ilp] := bChecked;
end;

procedure SetListBoxAllSelected(lst: TListBox; bChecked: boolean);
// Set all items in a multi select listbox to either selected or unselected.
var
  ilp: integer;
begin
  if lst.MultiSelect then
    begin
      for ilp := 0 to lst.Items.Count - 1 do
        lst.selected[ilp] := bChecked;
    end
  else
    showerrormessage(lst.Name + ' is not a multi-select listbox');
end;

procedure RemoveFromListBox(lst: TListBox; bAskFirst: boolean = true);
var
  ilp: integer;
  bOKToDelete: boolean;
begin
  //Ask, then remove selected items from lst.
  if bAskFirst then
    bOKToDelete := AskYesNo('Are you sure you want to remove the selected item(s)?')
  else
    bOKToDelete := true;

  if bOKToDelete then
    begin
      if lst.MultiSelect then
        begin
          for ilp := lst.items.Count - 1 downto 0 do
            begin
              //Remove the current item from the list
              if lst.selected[ilp] then
                lst.Items.Delete(ilp);
            end;
        end
      else
        begin
          if lst.ItemIndex > -1 then
            lst.Items.Delete(lst.ItemIndex)
          else
            showmessagebox('Please select an item to remove from the list.');
        end;
    end;
end;

procedure RemoveFromTreeView(tv: TTreeView; bAskFirst: boolean = true);
var
  bOKToDelete: boolean;
begin
  //Ask, then remove selected items from lst.
  if bAskFirst then
    bOKToDelete := AskYesNo('Are you sure you want to remove the selected item(s)?')
  else
    bOKToDelete := true;

  if bOKToDelete then tv.Selected.Delete;
end;

function AlreadyInListView(lv: TListview; sCaption: string): boolean;
begin
  Result := (ListviewIndexOfByCaption(lv, scaption) > -1);
end;

function ListViewIndexOfByCaption(lv: TListview; sCaption: string): integer;
// If a ListView *does* contain an item with a given caption, returns the index of that item.
var
  ilp: integer;
begin
  Result := -1;
  for ilp := 0 to lv.items.Count - 1 do
    begin
      if sametext(lv.items[ilp].Caption, sCaption) then
        begin
          Result := ilp;
          break;
        end;
    end;
end;

function FindTreeViewNodeByText(tv: TTreeView; sText: string): TTreeNode;
// TTreeViews have no way to tell us if a node with a particular caption already exists in
// that tree. This function will do that for you - useful to keep duplicates out of TTreeViews.
var
  oNode: TTreeNode;
begin
  Result := nil;
  oNode  := tv.Items.GetFirstNode;
  while oNode <> nil do
    begin
      if sametext(oNode.Text, sText) then
        begin
          Result := oNode;
          break;
        end;
      oNode := oNode.GetNext;
    end;
end;

function AlreadyInTreeView(tv: TTreeView; sCaption: string): boolean;
// Tells you if a TreeView already contain a node/element with a particular caption.
// Used to prevent duplicates from being added.
var
  oNode: TTreeNode;
begin
  Result := false;
  oNode  := tv.Items.GetFirstNode;
  while oNode <> nil do
    begin
      if sametext(oNode.Text, sCaption) then
        begin
          Result := true;
          break;
        end;
      oNode := oNode.GetNext;
    end;
end;

function AddItemToListBox(sLine: string; lstDest: Tlistbox;
    bPreventDuplicates: boolean = true): boolean;
var
  bOKToCopy: boolean;
begin
  if bPreventDuplicates then
    bOKToCopy := (lstDest.items.IndexOf(sLine) = -1)
  else
    bOKToCopy := true;

  if bOKToCopy then
    lstDest.Items.add(sLine);
  Result := bOKToCopy;
end;

function AddItemToListView(sLine: string; lvDest: Tlistview;
    bPreventDuplicates: boolean = true;slSubItems:TStrings=nil): boolean;
var
  oItem:    TListItem;
  bOKToAdd: boolean;
begin
  bOKToAdd := true;
  if bPreventDuplicates then
    bOKToAdd := not AlreadyInListView(lvDest, sLine);

  if bOKToAdd then
    begin
      oItem := lvDest.Items.add;
      oItem.Caption := sLine;
      if assigned(slSubItems) then
        oItem.subitems.Assign(slSubItems);
    end;
  Result := bOKToAdd;
end;

function CopyBetweenListBoxes(lstSource, lstDest: TListBox;
    bPreventDuplicates: boolean = true; bAutoHorizScroll: boolean = true): boolean;
var
  ilp:    integer;
  sToAdd: string;
begin
  Result := false;
  if lstSource.MultiSelect then
    begin
      for ilp := 0 to lstSource.items.Count - 1 do
        begin
          if lstSource.Selected[ilp] then
            AddItemToListbox(lstsource.items[ilp], lstDest, bPreventDuplicates);
        end;
    end
  else
    begin
      if lstSource.ItemIndex > -1 then
        begin
          sToAdd := lstSource.items[lstSource.ItemIndex];
          Result := AddItemToListBox(sToAdd, lstDest, bPreventDuplicates);
        end
      else
        showmessagebox('Please select an item before using this command.');
    end;
  if bAutoHorizScroll then
    SetListBoxHorizontalScroll(lstDest);
end;

function CopyBetweenListViews(lvSource, lvDest: TListView;
    bPreventDuplicates: boolean = true; bAutoHorizScroll: boolean = true): boolean;
var
  ilp:    integer;
  sToAdd: string;
begin
  Result := false;
  if lvSource.MultiSelect then
    begin
      for ilp := 0 to lvSource.items.Count - 1 do
        begin
          if lvSource.Items[ilp].Selected then
            begin
              AddItemToListView(lvSource.items[ilp].Caption, lvDest, bPreventDuplicates,
                    lvSource.items[ilp].subitems);
            end;
        end;
      Result := true; //Only an exception can prevent this being true.
                      //Adding from a multiselect lv will always return TRUE

                      //Don't want to make it equal to the result of
                      //AddItemTolistView, because that returns false if a dupe
                      //was added - what if it was the last one ? Even though
                      //the operation succeeded, we'd return false!
    end
  else
    begin
      if lvSource.selected <> nil then
        begin
          sToAdd := lvSource.selected.Caption;
          Result := AddItemToListView(sToAdd, lvDest, bPreventDuplicates,lvSource.selected.subitems);
          SetAllListViewColumnsToMaxWidth(lvDest);
        end
      else
        showmessagebox('Please select an item before using this command.');
    end;
end;

procedure SetListBoxHorizontalScroll(lst: TListBox);
// Adds a horizontal scroll bar to a TListBox if that box needs it. You don't need to
// do the test yourself - this function will test AND apply the bar if needed.
var
  i, StrWidth, MaxWidth, LBScrollWidth: integer;
begin
  {get max text width}
  MaxWidth := 0;
  for i := 0 to lst.Items.Count - 1 do
    begin
      begin
        StrWidth := lst.Canvas.TextWidth(lst.Items[i]);
        if StrWidth > MaxWidth then
          MaxWidth := StrWidth;
      end; {
      {calculate scroll width}
      LBScrollWidth := MaxWidth + 4; // plus 4 for borders;
      {set scroll width}
      if lbscrollwidth > lst.Width then
        lst.Perform(LB_SETHORIZONTALEXTENT, LBScrollWidth, 0);
    end;
end;

procedure MoveListViewItemToIndex(lv: TListView; oItemToMove: TListItem;
    iNewIndex: integer; bRetainSelectionAfterMove: boolean = true;bSwapItems:boolean=true);
// Allows you to move items in a TListView.
// could also use an overridden version which takes two indexes instead
var
  oNewItem,oTempItem: TListItem;
begin
  assert(iNewIndex >= 0);
  assert(iNewIndex <= lv.items.Count - 1);

  lv.Items.BeginUpdate;
  try
    if bSwapItems then
      begin
        //Throw in another list item
        oTempItem := lv.Items.add;
        //Copy the contents of the destination to this temp TListItem
        oTempItem.Assign(lv.items[iNewIndex]);
        //Now overwrite the destination
        lv.items[iNewIndex].Assign(oItemToMove);
        //Now write the temp list item over the original
        oItemToMove.Assign(oTempItem);
        oTempItem.Delete;
      end
    else
      begin
        //Use this branch to just have the list all shuffle up by one
        //to make room for the drag
        oNewItem := lv.Items.Insert(iNewIndex);
        oNewItem.Assign(oItemToMove);
        oItemToMove.Delete;
      end;
    if bRetainSelectionAfterMove then
      begin
        lv.Selected := nil; //Clears the selection
        lv.Selected := lv.items[iNewIndex];
      end;
  finally
    lv.Items.EndUpdate;
  end;
end;

function MedianInteger(x: TDIArray): integer;
{==== Median =========================================================}
//Lifted from http://www.efg2.com/Lab/Library/Delphi/MathFunctions/StatisticsLibrary.pas
var
  i:      integer;
  j:      integer;
  Middle: integer;
  Temporary: integer;
begin
  {Use truncated selection sort to find median}
  Middle := (High(x) + 1) div 2;

  for i := 0 to Middle do
    begin
      for j := 1 to High(x) - i do
        begin
          if x[j] > x[j - 1] then
            begin
              Temporary := x[j];
              x[j]      := x[j - 1];
              x[j - 1]  := Temporary
            end
        end
    end;

  if Odd(High(x)) then
    begin
      {When High(x) is Odd, there are an even number of elements in array.
       Define median as average of two middle values.}
       Result := (x[middle] + x[middle - 1]) div 2
    end
  else
    begin
      {When High(x) is Even, there are an odd number of elements in array.
       Median is the middle value.}
      Result := x[middle]
    end
end;                                             {MedianInteger}

function FormatAsMoney(fNumber:single;iPrecision:integer=2):string;
// Formats a numeric string with a dollar sign and limits to two decimal places.
begin
  //default to 2 digit precision, but allow caller to specify
  result := Format('$%.'+inttostr(iPrecision)+'f',[fNumber])
end;

function SortItNumerically(sl:TStringList;i1,i2:integer):integer;
var
iPiece1,iPiece2:integer;
begin
    iPiece1 := strtointdef(Piece(sl[i1],SINDelim,SINCol),0);
    iPiece2 := strtointdef(Piece(sl[i2],SINDelim,SINCol),0);
    result := CompareValue(iPiece1,iPiece2);
end;

procedure SortDataInStringList(var slData:TStringList;iCol:integer;sDelim:string=VISTADELIMITER;iMethod:integer=0);
// BSMITH
// Given a TStringList of "Piece" formatted data, this procedure will do an alphabetical
// sort on the whole dataset based on the Piece you specify.
var
  ilp:integer;
begin
  assert(iCol > 0,'iCol must be > 0 - we''re using Piece and it is one-based, not zero.');
  //given a TStringList where each line contains delimited data,
  //sort the whole lot based on the nth "piece" of each line (where nth=iCol)
  //
  //ie slData[0] = 'orange^dog^car'
  //   slData[1] = 'banana^zebra^train'
  //
  //You could call this procedure and tell it to sort on iCol = [1|2|3]
  //
  //ALPHABETICAL or NUMERIC SORT ONLY FOR NOW

  //How it's done- make a temp string list and copy only the whole original stringlist into it, with
  // and copy the nth piece to the start of each line. Sort it. Then delete the zeroth piece and assign it
  //back to the original string list.
  //Now sort them
  if iMethod = 0 then
  begin
      for ilp := 0 to slData.count-1 do
        slData[ilp] := Piece(slData[ilp],sDelim,iCol)+VISTADELIMITER + slData[ilp];
      slData.sort;
      //Now the work stringlist has a sorted list of the values we're using
      //sorted by the piece we asked for. Eliminate that zeroth piece
      for ilp := 0 to slData.count-1 do
        slData[ilp] := DeletePiece(slData[ilp],1,VISTADELIMITER,true);
  end
  else if iMethod = 1 then
  begin
    SINDelim := sDelim;
    SINCol := iCol;
    //Sort numerically
    slData.CustomSort(SortItNumerically);
  end;
end;

procedure HideTabs(pcPageControl:TPagecontrol);
// Will hide all the .Tabs on a TPageControl. Useful if you're building a wizard
// from a TPageControl and want to hide the tabs when the program runs, but leave
// them visible at designtime.
var
  ilp:integer;
begin
  for ilp := 0 to pcPagecontrol.PageCount-1 do
    pcPageControl.Pages[ilp].TabVisible := false;
end;

procedure ScrollToTop(ctl:TCustomEdit);
// Scroll a memobox or richedit up to the top.
begin
  ctl.SelStart := 0;
  SendMessage(ctl.handle, EM_SCROLLCARET,0,0)
end;

function GetWindowsUserName:string; var Size: Cardinal; FWinUserName: PChar;
begin
  Size := 0;
  result := '';
  GetUserName(nil, Size);
  // allocate
  FWinUserName := StrAlloc(Size);
  try
    if GetUserName(FWinUserName, Size) then
      //WinUserName := LowerCase(string(FWinUserName))
      result := (string(FWinUserName))
    else
      raise exception.create('Windows user name could not be found.');
  finally
    StrDispose(FWinUserName);
  end;
end;

function ListViewItemToString(oItem:TListItem;sDelimiter:string='^'):string;
var
  ilp:integer;
begin
  result := oItem.caption+sDelimiter;
  for ilp := 0 to oItem.subitems.count-1 do
    begin
      result := result + oItem.SubItems[ilp]+sDelimiter;
    end;
  result := rightcontrim(result,sDelimiter);
end;

function GetNodeRootParent(tv:TTreeView;oNode:TTreeNode):TTreeNode;
//for a given node in a treeview, pass back it's root level parent
begin
  result := nil;
  while oNode <> nil do
    begin
      if oNode.parent = nil then
        break
      else
        oNode := oNode.parent;
    end;
  result := oNode;
end;

procedure SelectFirstItem(ctl:TControl);
var
  lst:TListBox;
  lv:TListView;
begin
  if ctl is TListBox then
    begin
      lst := (ctl as TListBox);
      //Select the first one
      if lst.Items.Count > 0 then
        begin
          lst.ItemIndex := 0;
        end;
    end;
  if ctl is TListView then
    begin
      lv := (ctl as TListView);
      //Select the first one
      if lv.Items.Count > 0 then
        begin
          lv.ItemIndex := 0;
          lv.items[0].Selected := true;
        end;
    end;
end;
procedure AddDisableBMP(SB : array of TObject);
//copied from http://www.swissdelphicenter.ch/en/printcode.php?id=1865
var
  BM, SBM : TBitmap;
  w, x, y, NewColor, i : integer;
  PixelColor : TColor;
begin
  BM := TBitmap.Create;
  SBM := TBitmap.Create;
  try
    for i := 0 to High(SB) do
      begin
        if (SB[i] is TSpeedButton) then
          BM.Assign((SB[i] as TSpeedButton).Glyph)
        else if (SB[i] is TBitBtn) then
          BM.Assign((SB[i] as TBitBtn).Glyph)
        else
          Exit;

        if not Assigned(BM) or (BM.Width <> BM.Height) then Exit;

        w := BM.Width;
        SBM.Width := w * 2;
        SBM.Height := w;
        SBM.Canvas.Draw(0, 0, BM);

        for x := 0 to w - 1 do
          for y := 0 to w - 1 do
            begin
              PixelColor := ColorToRGB(BM.Canvas.Pixels[x, y]);
              NewColor := Round((((PixelColor shr 16) + ((PixelColor shr 8) and $00FF) +
                (PixelColor and $0000FF)) div 3)) div 2 + 96;
              BM.Canvas.Pixels[x, y] := RGB(NewColor, NewColor, NewColor);
            end;

        SBM.Canvas.Draw(w, 0, BM);

        if (SB[i] is TSpeedButton) then with (SB[i] as TSpeedButton) do
          begin
            Glyph.Assign(SBM);
            NumGlyphs := 2;
          end
        else
          with (SB[i] as TBitBtn) do
            begin
              Glyph.Assign(SBM);
              NumGlyphs := 2;
            end;
        BM := TBitmap.Create;
        SBM := TBitmap.Create;
      end;
  finally
    BM.Free;
    SBM.Free;
  end;
end;

function GetColumnIndexByName(lv:TListView;sHeading:string):integer;
var
  ilp:integer;
begin
  //If the number you expect to get back is for one of the "subitem" columns,
  //don't forget to subtract one from this result, or the SubItems[GetColumnINdex...
  //will be off by one.
  result := -1;

  for ilp := 0 to lv.Columns.Count-1 do
    begin
      if sametext(sHeading,lv.Columns[ilp].Caption) then
        begin
          result := ilp;
          break;
        end;
    end;
end;

function MakeTextTwoColumns(sAllText:string; iColWidth:integer):string;

  function PadString(const S: string; Len: Integer; PadChar: Char): string;
  //This routine was taken out of JvCsvParse.
  begin
    Result := S;
    while Length(Result) < Len do
      Result := Result + PadChar;
  end;

var
  slAll:TStringList;
  slCol1 : TStringList;
  slCol2 : TStringList;
  sLine,sTwoColText:string;
  iHalf,ilp:integer;
begin
  slAll:= TStringList.create;
  slCol1 := TStringList.create;
  slCol2 := TStringList.create;
  try
    ParseLine(sAlltext,crlf,slAll);
    iHalf := slAll.Count div 2;
    for ilp := 0 to slAll.count-1 do
      begin
        if ilp >= iHalf then
          slCol2.Add(slAll[ilp])
        else
          slCol1.add(slAll[ilp]);
      end;
    slCol1.text := MyWraptext(slCol1.text,iColWidth);
    slCol2.text := MyWraptext(slCol2.text,iColWidth);

    sTwoColtext := '';
    for ilp := 0 to Max(slCol1.Count-1,slCol2.count-1) do
      begin
        sLine := '';
        if (ilp < slCol1.count) then
          sLine := sLine + PadString(slCol1[ilp],iColWidth,' ')
        else
          sLine := sLine + stringofchar(' ',iColWidth);
        if (ilp < slCol2.count) then
          sLine := sLine + PadString(slCol2[ilp],iColWidth,' ')
        else
          sLine := sLine + stringofchar(' ',iColWidth);

        sTwoColText := sTwoColText + sLine+crlf;
      end;
    result := sTwoColText;
  finally
    slCol1.free;
    slCol2.free;
    slAll.free;
  end;
end;

function MapExtended(fNumber,fOriginalLow,fOriginalHigh,fNewLow,fNewHigh:extended):extended;
var
  fPos:extended;
begin
  if foriginalHigh = fOriginalLow then
    result := 0.0
  else
    begin
      //take a number n between A and B, and "map" it to a new scale,
      //i.e a number that lies between 0 and 255 and turn it to the same point
      //between 0 and 100, i.e a percentage
      fPos :=(fNumber-foriginallow)/(fOriginalHigh-fOriginalLow);
      result := fNewLow + (fPos*(fNewhigh-fNewLow));
    end;
end;

function MapInteger(iNumber,iOriginalLow,iOriginalHigh,iNewLow,iNewHigh:integer):integer;
var
  fPos:extended;
begin
  if iOriginalHigh = iOriginalLow then
    result := 0
  else
    begin
      //take a number n between A and B, and "map" it to a new scale,
      //i.e a number that lies between 0 and 255 and turn it to the same point
      //between 0 and 100, i.e a percentage
      fPos :=(iNumber-iOriginalLow)/(iOriginalHigh-iOriginalLow);
      result := iNewLow + round(fPos*(iNewhigh-iNewLow));
    end;
end;

function DoIExist(WndTitle: string): boolean;
{!!2.3 See if application already is loaded and executing.  Return TRUE if so.
 Usage:
  if DoIExist(Application.Title) = TRUE then
    begin
      ShowMessage( Application.Title + ' already is running.  You cannot run multiple copies of this application.' );
      Application.Terminate;
      Exit;
    end;
}
var
  A : array [0..255] of char;
  semNm : array[0..255] of char;
  wTtl  : array[0..255] of char;
  hWndMe : HWnd;
  hSem  :   THandle;
begin
  Result := FALSE;

  //Copy the Pascal strings into the Arrays of Char;
  StrPCopy(semNm, WndTitle);
  StrPCopy(wTtl, WndTitle);

  //Create a Semaphore in memory
  hSem := CreateSemaphore(nil, 0, 1, semNm);

  //Now, check to see if the semaphore exists
  if ((hSem <> 0) and (GetLastError() = ERROR_ALREADY_EXISTS)) then
    begin
      CloseHandle(hSem);

      //We'll first get the currently executing window's handle then change its title
      //so we can look for the other instance
      hWndMe := FindWindow(nil, wTtl);
      StrPCopy(A, 'Copy of: ' + Application.Title);
      SetWindowText(hWndMe, A);

      //What we want to do now is search for the other instance of this window
      //then bring it to the top of the Z-order stack.
      hWndMe := FindWindow(nil, wTtl);
      if (hWndMe <> 0) then
        begin
          if IsIconic(hWndMe) then
            ShowWindow(hWndMe, SW_SHOWNORMAL)
          else
            SetForegroundWindow(hWndMe);
        end;

      Result := TRUE;

      //Could put the Halt here, instead of in the FormCreate method,
      //unless you want to do some extra processing.
      //Halt;
    end;
end;

function StrCSpn(Str: string; Chars: TCharSet; Idx: integer): integer;
var
  i: integer;
begin
  Result := Length(Str) - Idx + 1;
  for i := Idx to Length(Str) do
  begin
    if Str[i] in Chars then
    begin
      Result := i - Idx;
      Exit;
    end;
  end;
end;

function StrSpn(Str: string; Chars: TCharSet; Idx: integer): integer;
var
  i: integer;
begin
  Result := Length(Str) - Idx + 1;
  for i := Idx to Length(Str) do
  begin
    if not (Str[i] in Chars) then
    begin
      Result := i - Idx;
      Exit;
    end;
  end;
end;

end.
